﻿using System;


using System.Configuration;


using System.ServiceModel;


using System.ServiceModel.Description;


using Microsoft.ServiceBus;


using Microsoft.ServiceBus.Description;




namespace AzureSample
{



    class Program
    {



        static void Main(string[] args)
        {

            try
            {

                string endPoint = ConfigurationSettings.AppSettings["EndPoint"];



                string issuerName = ConfigurationSettings.AppSettings["UserName"];



                string issuerKey = ConfigurationSettings.AppSettings["Password"];





                Uri uri = new
                Uri(endPoint);





                TransportClientEndpointBehavior sharedSecretServiceBusCredential = new TransportClientEndpointBehavior();
                sharedSecretServiceBusCredential.CredentialType = TransportClientCredentialType.SharedSecret;
                sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerName = issuerName;
                sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerSecret = issuerKey;





                ServiceHost host = new
                ServiceHost(typeof(LogService), uri);





                ContractDescription contractDescription = ContractDescription.GetContract(typeof(ILogContract), typeof(LogService));





                ServiceEndpoint serviceEndPoint = new
                ServiceEndpoint(contractDescription);


                serviceEndPoint.Address = new
                EndpointAddress(uri);


                serviceEndPoint.Binding = new
                NetTcpRelayBinding();


                serviceEndPoint.Behaviors.Add(sharedSecretServiceBusCredential);
                host.Description.Endpoints.Add(serviceEndPoint);
                host.Open();

                Console.WriteLine(String.Format("Listening at: {0}", endPoint));



                Console.WriteLine("Press [Enter] to exit");



                Console.ReadLine();




                host.Close();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);

            }



        }


    }


}

